
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 15 10:19:22 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_RC4FLOW_Acceptance_test_vectors.c#1:csrc:1
   *  \author 
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */   
   
/***************************
 * File Name:                                                           
 *  RYS_SYS_TST_DESFLOW_Acceptance_test_vectors.c       
 *
 * Description:                                                                 
 *  This file contatind the test vectors used for OTF Acceptance tests                              
 *
 **************************/
 
 
 /***** Include Files ******/
#include "CRYS_ATP_TST_RC4FLOW_Acceptance.h"

#if TST_USE_FLOW_DATA/*In case no test vectors are selected - code disabled*/

#if FLOW_RC4_Support

/******** Defines ********/
/******** Enums **********/
/******** Typedefs *********/
/******** Global Data ********/
/***** Private function prototype ******/
/****** **** Public Functions *****/
/******** Private Functions ******/
/*****************************/
/************** External Key Vectors  ********/
/*****************************/


TST_RC4FLOW_TestDataStruct TST_RC4FLOW_Acceptance_TestData[] =
{
        /************/
        /*        FLOW vectors         */
        /************/
        #if TST_USE_FLOW_RC4_5BYTE_KEY
        { 
		{"Acceptance flow test - RC4/5ByteKey/512ByteData "},
			/* input interrupt id */
			6,

			/* output interrupt id */
			7,

			/* if the data in the buffers are in words and not bytes */ 
			0,

			/* number of input buffers */
			4,

			/* flag if  endian order of the input buffers is big */
			0,

			/* number of output buffers */
			4,
			0,
			/* TST_Expected_output_data */
		{
			0xB2,0xE6,0x3B,0xFC,0x8E,0x06,0x9F,0x7F,0xA5,0x66,0x3A,0xF0,0x5D,0x5C,0x32,0x52,
            0x99,0xE9,0xFB,0xCE,0xC3,0x8D,0x3C,0x9E,0xD8,0x0D,0x29,0x00,0x10,0x44,0x18,0xE9,
            0xFC,0x83,0xE6,0x06,0x78,0xBF,0x22,0x9C,0x16,0x5B,0x6A,0x15,0xD4,0x14,0xA6,0x8F,
            0x44,0x22,0xB1,0xA9,0x2D,0xAF,0x95,0x6D,0x99,0x77,0xC3,0xC9,0x51,0x26,0xCE,0x1C,
            0x23,0xDE,0x54,0xD4,0x0C,0xE4,0x65,0x12,0x9C,0xD6,0xE5,0x1D,0xA0,0x21,0xFC,0x85,
            0x65,0x70,0x8D,0x3F,0x12,0x89,0x98,0x1F,0x0D,0xF2,0x01,0xE1,0x6F,0x41,0x51,0xF6,
            0xD1,0xEC,0xC9,0xD1,0x60,0xB1,0xED,0x72,0xA7,0x48,0xD7,0xCF,0x54,0x7C,0xA4,0x93,
            0xE3,0x46,0xAD,0xF5,0xB6,0x97,0xA2,0xDB,0xA3,0xED,0xB3,0xA2,0x93,0x0E,0xD9,0x81,
            0x62,0x3D,0x88,0x9E,0x3B,0x84,0xC9,0x08,0xE3,0x7D,0x1A,0xB6,0x10,0x89,0x76,0xF1,
            0x9E,0xFE,0xEB,0xEA,0xF9,0xF5,0xF7,0xCC,0xA7,0xE3,0xF1,0x78,0x21,0x00,0x74,0x54,
            0xA4,0x02,0xB1,0xD0,0x14,0x1F,0x5B,0x3D,0x75,0xBD,0x6A,0x42,0x96,0x6A,0xC8,0xB8,
            0xC2,0x67,0x07,0x47,0xE7,0x25,0x2B,0x76,0x34,0x1C,0x32,0x73,0x9F,0x76,0x43,0x7E,
            0x92,0x6D,0x5E,0x35,0xD6,0x8D,0xDC,0xF6,0x11,0x03,0xAC,0xF6,0x30,0x35,0x7E,0xE7,
            0x8E,0x14,0xA4,0x35,0xAE,0x2F,0x98,0x82,0x6A,0x77,0x8C,0x94,0x99,0x61,0x6C,0xEE,
            0x03,0xD0,0x5A,0xCD,0xE0,0x1D,0x56,0xA1,0x04,0x49,0x14,0x3B,0xF7,0xCD,0xFC,0x3D,
            0x5B,0x14,0xED,0x33,0x26,0x94,0x8D,0x99,0xF9,0x78,0x3A,0x51,0xE5,0x6E,0x44,0x85,
            0x7D,0x96,0xFD,0xA7,0xF8,0xA2,0xE3,0x7B,0xA4,0x89,0x36,0xA7,0x82,0xAA,0x54,0x32,
            0x47,0xE5,0x9F,0xA0,0xD5,0x46,0x1B,0xEC,0xB4,0x6E,0x80,0xCF,0x21,0x30,0x7C,0x0B,
            0x51,0x1C,0x18,0x0D,0x58,0x28,0x42,0x2B,0xE6,0x61,0x7B,0xDF,0x4D,0x68,0xE3,0xEA,
            0x79,0x49,0xD8,0xE5,0xEA,0x8B,0xBB,0xE4,0x33,0x6B,0x02,0x86,0x16,0x28,0xF5,0x78,
            0xD5,0x4D,0xC9,0x91,0x91,0x5F,0x31,0x3F,0xD2,0xB9,0x90,0x3A,0x32,0x26,0x4F,0xDB,
            0xCF,0x5A,0xE8,0x3C,0x37,0xB7,0x9D,0x66,0xD2,0x53,0x31,0x77,0xBB,0x39,0xD9,0x41,
            0xC6,0x85,0x6E,0xE9,0xDF,0xC2,0xF9,0x32,0xE8,0x73,0x8A,0xE7,0x84,0xCB,0xC0,0x38,
            0xEB,0x97,0xA8,0x91,0xA9,0x5E,0x3A,0xD8,0xA0,0xB3,0x2B,0x3A,0x21,0x54,0x0C,0xDD,
            0x2D,0x9A,0x8C,0x05,0x3A,0xC6,0x44,0xBA,0x03,0xE2,0xED,0x6C,0x12,0xD9,0xC5,0xDE,
            0xA8,0x5B,0xDF,0x5F,0x78,0x8A,0xE7,0x4A,0xA8,0x80,0x0C,0x27,0x69,0xDA,0xC7,0x31,
            0xB7,0x8F,0x07,0x7F,0x9B,0x9B,0x84,0xA3,0x50,0x5B,0xAC,0xF8,0xB2,0x60,0x8D,0xE9,
            0x1E,0x51,0x2D,0xA1,0x1F,0x49,0xE5,0x3B,0xAF,0xAF,0xE7,0x93,0x6B,0xB2,0xC7,0xBB,
            0xE9,0x1D,0x6D,0x03,0x03,0x8D,0x9A,0x2F,0x32,0xAE,0xD7,0x14,0xB1,0x63,0xEA,0xE2,
            0x68,0xC7,0xA9,0x9E,0xCD,0x5A,0x23,0x5F,0x2B,0x62,0xF3,0x02,0xC0,0x71,0x93,0x0B,
            0x46,0x6D,0xD6,0xFF,0x32,0x48,0x80,0x8F,0x04,0x58,0x2D,0x9A,0x31,0x63,0xB0,0x5B,
            0xDD,0x33,0xAC,0x0A,0xD8,0xD7,0x52,0xC7,0x34,0x3F,0x0D,0x8B,0x3A,0xAB,0xDA,0xB4
		},
		
		/* TST_Expected_cyclicOperation_data */
		{
		    0xB2,0xE6,0x3B,0xFC,0x8E,0x06,0x9F,0x7F,0xA5,0x66,0x3A,0xF0,0x5D,0x5C,0x32,0x52,
            0x99,0xE9,0xFB,0xCE,0xC3,0x8D,0x3C,0x9E,0xD8,0x0D,0x29,0x00,0x10,0x44,0x18,0xE9,
            0xFC,0x83,0xE6,0x06,0x78,0xBF,0x22,0x9C,0x16,0x5B,0x6A,0x15,0xD4,0x14,0xA6,0x8F,
            0x44,0x22,0xB1,0xA9,0x2D,0xAF,0x95,0x6D,0x99,0x77,0xC3,0xC9,0x51,0x26,0xCE,0x1C,
            0x23,0xDE,0x54,0xD4,0x0C,0xE4,0x65,0x12,0x9C,0xD6,0xE5,0x1D,0xA0,0x21,0xFC,0x85,
            0x65,0x70,0x8D,0x3F,0x12,0x89,0x98,0x1F,0x0D,0xF2,0x01,0xE1,0x6F,0x41,0x51,0xF6,
            0xD1,0xEC,0xC9,0xD1,0x60,0xB1,0xED,0x72,0xA7,0x48,0xD7,0xCF,0x54,0x7C,0xA4,0x93,
            0xE3,0x46,0xAD,0xF5,0xB6,0x97,0xA2,0xDB,0xA3,0xED,0xB3,0xA2,0x93,0x0E,0xD9,0x81,
            0x62,0x3D,0x88,0x9E,0x3B,0x84,0xC9,0x08,0xE3,0x7D,0x1A,0xB6,0x10,0x89,0x76,0xF1,
            0x9E,0xFE,0xEB,0xEA,0xF9,0xF5,0xF7,0xCC,0xA7,0xE3,0xF1,0x78,0x21,0x00,0x74,0x54,
            0xA4,0x02,0xB1,0xD0,0x14,0x1F,0x5B,0x3D,0x75,0xBD,0x6A,0x42,0x96,0x6A,0xC8,0xB8,
            0xC2,0x67,0x07,0x47,0xE7,0x25,0x2B,0x76,0x34,0x1C,0x32,0x73,0x9F,0x76,0x43,0x7E,
            0x92,0x6D,0x5E,0x35,0xD6,0x8D,0xDC,0xF6,0x11,0x03,0xAC,0xF6,0x30,0x35,0x7E,0xE7,
            0x8E,0x14,0xA4,0x35,0xAE,0x2F,0x98,0x82,0x6A,0x77,0x8C,0x94,0x99,0x61,0x6C,0xEE,
            0x03,0xD0,0x5A,0xCD,0xE0,0x1D,0x56,0xA1,0x04,0x49,0x14,0x3B,0xF7,0xCD,0xFC,0x3D,
            0x5B,0x14,0xED,0x33,0x26,0x94,0x8D,0x99,0xF9,0x78,0x3A,0x51,0xE5,0x6E,0x44,0x85,
            0x99,0x88,0x58,0x9E,0x68,0xCF,0x8B,0x67,0xE2,0xE6,0x02,0xAF,0x61,0x34,0x23,0xAA,
            0xA3,0x6A,0x37,0x9F,0x88,0x82,0xFA,0x05,0xF7,0x47,0x21,0x55,0x6F,0xD2,0xC4,0x55,
            0xF4,0x03,0x9D,0x99,0x92,0xB4,0x08,0x4A,0xB6,0xD6,0xFE,0xF3,0x85,0x6B,0xFB,0x76,
            0xB8,0x60,0xF9,0x8E,0x52,0x8E,0x5D,0x0F,0x22,0xE4,0x27,0xA9,0xD2,0x3B,0x3D,0x6B,
            0xAD,0x7A,0x1A,0xE1,0xDC,0x84,0x84,0xA1,0xBF,0x3D,0x36,0x59,0x65,0xD7,0x44,0x6B,
            0x69,0x5A,0x03,0x26,0x1A,0x32,0x79,0x56,0xB6,0x9B,0x45,0x76,0x25,0xF9,0x8F,0x04,
            0x53,0xE1,0x06,0xA5,0x20,0x77,0xCE,0x84,0xB7,0x37,0x13,0xCA,0xF0,0xAB,0x0F,0x1D,
            0xAF,0xAF,0xA3,0x74,0x7E,0x9C,0x1C,0x13,0x57,0x50,0x54,0x66,0x3E,0x04,0xA8,0xA4,
            0x73,0xFF,0xCB,0xCC,0x1C,0xF0,0x37,0xA9,0x18,0x91,0xFF,0xA6,0xCB,0xE9,0x39,0xF4,
            0x4E,0xD4,0xDE,0x5E,0x83,0x4C,0x9E,0x33,0xA7,0xC9,0x15,0xBF,0xDD,0x7A,0x12,0xED,
            0xE7,0xF4,0x5A,0x64,0xA7,0x11,0x74,0x1F,0x7A,0x20,0x10,0xA1,0xED,0xA3,0xE3,0x1F,
            0x47,0x4B,0x75,0x04,0xFD,0xCA,0xCD,0x25,0x64,0x61,0x27,0x57,0x32,0x61,0xC5,0x78,
            0x7F,0x8F,0xC0,0x04,0x30,0xE4,0x29,0x87,0xA7,0x4B,0x53,0x29,0x6D,0x72,0xAD,0xE1,
            0x84,0x24,0xF8,0x86,0xD9,0x5D,0x99,0xDD,0xD9,0xCB,0x3D,0x53,0xE0,0x73,0xA3,0xA6,
            0xB3,0x57,0x94,0x3D,0x69,0xC7,0x77,0x73,0x04,0xA2,0x83,0xFD,0x9B,0x40,0x21,0x2C,
            0x03,0x09,0x37,0x37,0x51,0x17,0xFF,0x8E,0x94,0xFD,0x32,0xE8,0x9F,0x39,0x78,0x0A
		},
		/*TST_Key*/
        {0x02,0x0c,0xdd,0x0c,0x4a},
        /*TST_KeySize*/
        5*sizeof(DxUint8_t),
	},
	#endif
    #if TST_USE_FLOW_RC4_8BYTE_KEY
        { 
		{"Acceptance flow test - RC4/8ByteKey/512ByteData "},
			/* input interrupt id */
			6,

			/* output interrupt id */
			7,

			/* if the data in the buffers are in words and not bytes */ 
			0,

			/* number of input buffers */
			2,

			/* flag if  endian order of the input buffers is big */
			0,

			/* number of output buffers */
			2,
			0,
			/* TST_Expected_output_data */
		{
			0x65,0x8B,0xF3,0x88,0x9A,0xA4,0x08,0x1C,0x27,0x5B,0xA2,0x27,0x95,0xDC,0x5B,0xB0,
            0x2B,0x9D,0x9A,0xCD,0xEF,0xBA,0xFD,0xCD,0x35,0xD3,0xF2,0x4A,0xD8,0xB9,0xA9,0xD3,
            0x25,0x49,0x78,0x3E,0xEB,0x44,0xE4,0xFF,0x4A,0x88,0xB9,0x39,0xAD,0x15,0x6B,0xE6,
            0x65,0x90,0xF8,0x9B,0x8F,0x93,0xCA,0x01,0x69,0x00,0xA1,0xB3,0xA0,0x15,0x51,0x92,
            0xF0,0xCD,0xCD,0x70,0xD0,0xCA,0x83,0x51,0x3F,0xF4,0x25,0x0E,0x74,0xBF,0x47,0x4A,
            0x39,0x03,0x16,0x7E,0x32,0xE9,0x9D,0x4A,0x81,0x5F,0xBA,0xE6,0x59,0x35,0xB2,0xD3,
            0xD1,0xFD,0xE8,0x71,0x46,0xDC,0xE2,0x78,0xA0,0x9E,0x72,0x8D,0x5D,0x84,0x48,0xF1,
            0xBE,0x5D,0x4D,0x37,0x2F,0xDE,0xC8,0x84,0x38,0x25,0x5B,0x92,0xA5,0xB6,0x8F,0xF8,
            0x3E,0x8C,0x8B,0x32,0x3C,0xF8,0xDB,0xD9,0x8F,0xDF,0x10,0x86,0xAC,0xB6,0x7E,0x45,
            0xB9,0xDE,0x46,0x2B,0xD9,0xD5,0xB2,0xCA,0xB1,0xB5,0x89,0x78,0xE6,0xE8,0x40,0x13,
            0xD7,0x4F,0x0F,0x21,0x94,0x02,0xD9,0xDF,0x43,0x7F,0x46,0xB3,0x95,0x1C,0xE1,0x79,
            0x29,0xEC,0xC2,0x28,0xE0,0xFD,0x91,0x49,0x3C,0xCD,0x97,0x66,0x07,0x9C,0x64,0x56,
            0xB6,0xBE,0xC1,0x2E,0x99,0x72,0x5A,0xBA,0x71,0xA0,0x39,0xC7,0x74,0x21,0x60,0xFA,
            0x0A,0x97,0x3C,0xA1,0x16,0x92,0x76,0x73,0x94,0xC9,0x37,0x91,0x25,0xD7,0x14,0x63,
            0xFC,0x8F,0x1D,0xC9,0x87,0xA6,0x10,0x9B,0x2C,0x14,0xE0,0x51,0xBF,0x92,0x11,0x16,
            0x3E,0x8C,0xC1,0xD0,0x9C,0xEF,0x73,0xE3,0x17,0x3A,0xDD,0x05,0x85,0xFC,0x00,0x19,
            0x9B,0x5B,0x37,0xE3,0xC0,0x37,0xB7,0x41,0x92,0x1D,0xC0,0xA6,0xBC,0x5F,0xFC,0xCB,
            0x02,0x58,0xE2,0x5B,0x7E,0x19,0xDD,0xC8,0x50,0x73,0x24,0xE3,0x49,0x5C,0xC3,0x70,
            0x6D,0xE6,0x76,0xA0,0x9F,0x61,0xEE,0x67,0xFB,0xDC,0x44,0x0A,0xD1,0xC6,0x79,0xAF,
            0x9E,0x03,0x24,0x41,0x39,0x51,0x2F,0x42,0xB8,0xFE,0xA8,0xE3,0x05,0x27,0x02,0x58,
            0xD0,0xAD,0x25,0xEA,0xD2,0x6E,0x6F,0x32,0xF0,0xA0,0xF3,0x15,0xA4,0xE0,0x36,0xF1,
            0xE7,0xE0,0x9F,0x03,0xB5,0x40,0x66,0xBB,0x06,0xA7,0x6C,0xB6,0x19,0xB4,0xDC,0x4B,
            0xAD,0xC7,0x2E,0xC6,0xD6,0x1B,0x41,0xB2,0xB7,0x56,0x6E,0xBE,0xEF,0x7E,0x58,0x12,
            0x30,0xB5,0x29,0xFE,0x70,0xD1,0xDD,0x4E,0x14,0xB3,0x75,0xDC,0xBB,0xFF,0x23,0x12,
            0x08,0x3F,0xB1,0x13,0xBF,0x2C,0xA2,0x6E,0xC8,0x5C,0xB9,0xE6,0x24,0x5B,0xBD,0xED,
            0x2B,0x83,0x89,0xF4,0x7B,0xAA,0xF9,0xA1,0x4F,0x48,0x6F,0x0D,0x3E,0x76,0x2D,0xF8,
            0xCB,0xF2,0x05,0x4A,0x9F,0x18,0x40,0x25,0x00,0xD7,0xE1,0x2C,0xB3,0x5E,0xFE,0x61,
            0x13,0x18,0x05,0xF8,0xF4,0xAA,0x37,0x7E,0xE4,0x2A,0x3A,0xF1,0x47,0xC5,0x96,0x73,
            0x90,0x82,0x7A,0x72,0xE0,0x03,0x6F,0x28,0xFA,0x43,0x56,0x9B,0xC7,0x2A,0xF2,0x8F,
            0x44,0xA8,0x30,0xEB,0x2B,0x39,0x82,0xAB,0xAB,0x40,0xB2,0xE4,0x50,0x54,0x2F,0x3B,
            0x7E,0x85,0xEA,0xC1,0xF7,0x41,0x24,0x87,0xA2,0x70,0x8F,0x56,0xB7,0x62,0xB4,0x82,
            0x49,0x39,0x08,0x68,0xD9,0x55,0x0C,0xF5,0x10,0x48,0x48,0x74,0x13,0x30,0xE1,0x6E
		},
		
		/* TST_Expected_cyclicOperation_data */
		{
		    0x65,0x8B,0xF3,0x88,0x9A,0xA4,0x08,0x1C,0x27,0x5B,0xA2,0x27,0x95,0xDC,0x5B,0xB0,
            0x2B,0x9D,0x9A,0xCD,0xEF,0xBA,0xFD,0xCD,0x35,0xD3,0xF2,0x4A,0xD8,0xB9,0xA9,0xD3,
            0x25,0x49,0x78,0x3E,0xEB,0x44,0xE4,0xFF,0x4A,0x88,0xB9,0x39,0xAD,0x15,0x6B,0xE6,
            0x65,0x90,0xF8,0x9B,0x8F,0x93,0xCA,0x01,0x69,0x00,0xA1,0xB3,0xA0,0x15,0x51,0x92,
            0xF0,0xCD,0xCD,0x70,0xD0,0xCA,0x83,0x51,0x3F,0xF4,0x25,0x0E,0x74,0xBF,0x47,0x4A,
            0x39,0x03,0x16,0x7E,0x32,0xE9,0x9D,0x4A,0x81,0x5F,0xBA,0xE6,0x59,0x35,0xB2,0xD3,
            0xD1,0xFD,0xE8,0x71,0x46,0xDC,0xE2,0x78,0xA0,0x9E,0x72,0x8D,0x5D,0x84,0x48,0xF1,
            0xBE,0x5D,0x4D,0x37,0x2F,0xDE,0xC8,0x84,0x38,0x25,0x5B,0x92,0xA5,0xB6,0x8F,0xF8,
            0x3E,0x8C,0x8B,0x32,0x3C,0xF8,0xDB,0xD9,0x8F,0xDF,0x10,0x86,0xAC,0xB6,0x7E,0x45,
            0xB9,0xDE,0x46,0x2B,0xD9,0xD5,0xB2,0xCA,0xB1,0xB5,0x89,0x78,0xE6,0xE8,0x40,0x13,
            0xD7,0x4F,0x0F,0x21,0x94,0x02,0xD9,0xDF,0x43,0x7F,0x46,0xB3,0x95,0x1C,0xE1,0x79,
            0x29,0xEC,0xC2,0x28,0xE0,0xFD,0x91,0x49,0x3C,0xCD,0x97,0x66,0x07,0x9C,0x64,0x56,
            0xB6,0xBE,0xC1,0x2E,0x99,0x72,0x5A,0xBA,0x71,0xA0,0x39,0xC7,0x74,0x21,0x60,0xFA,
            0x0A,0x97,0x3C,0xA1,0x16,0x92,0x76,0x73,0x94,0xC9,0x37,0x91,0x25,0xD7,0x14,0x63,
            0xFC,0x8F,0x1D,0xC9,0x87,0xA6,0x10,0x9B,0x2C,0x14,0xE0,0x51,0xBF,0x92,0x11,0x16,
            0x3E,0x8C,0xC1,0xD0,0x9C,0xEF,0x73,0xE3,0x17,0x3A,0xDD,0x05,0x85,0xFC,0x00,0x19,
            0x7F,0x45,0x92,0xDA,0x50,0x5A,0xDF,0x5D,0xD4,0x72,0xF4,0xAE,0x5F,0xC1,0x8B,0x53,
            0xE6,0xD7,0x4A,0x64,0x23,0xDD,0x3C,0x21,0x13,0x5A,0x85,0x79,0x07,0xBE,0x7B,0x2E,
            0xC8,0xF9,0xF3,0x34,0x55,0xFD,0xA4,0x06,0xAB,0x6B,0xC1,0x26,0x19,0xC5,0x61,0x33,
            0x5F,0x2A,0x05,0x2A,0x81,0x54,0xC9,0xA9,0xA9,0x71,0x8D,0xCC,0xC1,0x34,0xCA,0x4B,
            0xA8,0x9A,0xF6,0x9A,0x9F,0xB5,0xDA,0xAC,0x9D,0x24,0x55,0x76,0xF3,0x11,0x3D,0x41,
            0x41,0xE0,0x74,0x19,0x98,0xC5,0x82,0x8B,0x62,0x6F,0x18,0xB7,0x87,0x74,0x8A,0x0E,
            0x38,0xA3,0x46,0x8A,0x29,0xAE,0x76,0x04,0xE8,0x12,0xF7,0x93,0x9B,0x1E,0x97,0x37,
            0x74,0x8D,0x22,0x1B,0xA7,0x13,0xFB,0x85,0xE3,0x50,0x0A,0x80,0xA4,0xAF,0x87,0x6B,
            0x56,0x5A,0xF6,0xDA,0x99,0x1A,0xD1,0x7D,0xD3,0x2F,0xAB,0x2C,0xFD,0x6B,0x41,0xC7,
            0xCD,0x0C,0x88,0xF5,0x80,0x6C,0x80,0xD8,0x40,0x01,0x76,0x95,0x8A,0xD6,0xF8,0x24,
            0x9B,0x89,0x58,0x51,0xA3,0x92,0xB0,0x99,0x2A,0xAC,0x5D,0x75,0xEC,0x9D,0x90,0x97,
            0x4A,0x02,0x5D,0x5D,0x16,0x29,0x1F,0x60,0x2F,0xE4,0xFA,0x35,0x1E,0x16,0x94,0xB0,
            0x06,0x10,0xD7,0x75,0xD3,0x6A,0xDC,0x80,0x6F,0xA6,0xD2,0xA6,0x1B,0x3B,0xB5,0x8C,
            0xA8,0x4B,0x61,0xF3,0x3F,0x3E,0x38,0x29,0x59,0xE9,0x7C,0xB5,0x70,0x56,0x1F,0x96,
            0x8B,0xBF,0xA8,0x03,0xAC,0xCE,0xD3,0x7B,0xA2,0x8A,0x21,0x31,0x1D,0x41,0x25,0xF5,
            0x97,0x03,0x93,0x55,0x50,0x95,0xA1,0xBC,0xB0,0x8A,0x77,0x17,0xB6,0xA2,0x43,0xD0
		},
		/*TST_Key*/
        {0x80,0xf7,0xfe,0x0d,0x84,0x2d,0x48,0x92},
        /*TST_KeySize*/
        8*sizeof(DxUint8_t)
	},
	#endif
    #if TST_USE_FLOW_RC4_16BYTE_KEY
        { 
		{"Acceptance flow test - RC4/16ByteKey/512ByteData "},
			/* input interrupt id */
			0,

			/* output interrupt id */
			1,

			/* if the data in the buffers are in words and not bytes */ 
			0,

			/* number of input buffers */
			2,

			/* flag if  endian order of the input buffers is big */
			0,

			/* number of output buffers */
			2,
			0,
			/* TST_Expected_output_data */
		{
			0x27,0xB3,0x5B,0xDC,0x64,0xCA,0xB1,0x4A,0x37,0x2A,0x75,0xEA,0x3A,0x87,0xA3,0x46,
            0x36,0xCA,0x24,0x05,0x02,0x55,0x37,0x9E,0xAF,0x7E,0xB9,0x49,0x20,0x67,0x60,0x32,
            0xBF,0xD0,0x86,0x68,0x80,0x37,0x5D,0xF9,0xF4,0xBE,0xB0,0x6B,0x07,0x16,0x64,0xED,
            0xF9,0x1A,0xB8,0x24,0x5C,0xE0,0xDB,0xDD,0x70,0x94,0x0A,0xF1,0x4A,0x9E,0x90,0xFE,
            0x57,0xFC,0x68,0x4A,0xC5,0x1C,0x2C,0x18,0x6B,0xB2,0x89,0x49,0xA6,0x65,0xC0,0x3C,
            0x40,0xBA,0xB2,0x51,0xC8,0x43,0x4F,0xA0,0xAA,0x2C,0x4C,0x87,0xAF,0xFD,0x9D,0x2E,
            0x19,0xA7,0x66,0x1D,0x7E,0x26,0x92,0x20,0x16,0xB6,0x93,0xFD,0xAD,0xF3,0xAE,0x5A,
            0xD9,0xD6,0x0A,0xDC,0x9A,0x09,0xE2,0x31,0x0D,0x2A,0x17,0xC3,0x0F,0x9C,0x76,0xFD,
            0x86,0x9E,0xF8,0xC0,0xF2,0x23,0x76,0xAA,0x2C,0x2D,0x76,0x02,0xCB,0x3B,0x44,0xE3,
            0x41,0x3A,0x5F,0x2C,0xF4,0x8B,0x75,0xB9,0x66,0x52,0x68,0x57,0x23,0x4C,0x06,0x47,
            0x03,0xEA,0xC5,0x1B,0xCB,0x86,0x45,0x10,0x10,0x0A,0x25,0xA4,0x84,0xD5,0x61,0xE2,
            0x1D,0xF6,0x35,0xFF,0xF2,0x0E,0x25,0xFA,0x10,0x61,0x54,0xA1,0xBE,0xB4,0x27,0x58,
            0x91,0x35,0x37,0x86,0x41,0x9E,0x87,0x5D,0x0C,0x33,0x1E,0x4A,0xD1,0x5F,0x17,0x06,
            0xD6,0x6E,0x27,0x82,0x1D,0x51,0x63,0x62,0x07,0x06,0x62,0x9B,0x73,0xC9,0xD3,0x1E,
            0x6C,0x55,0xEF,0x71,0xDC,0x75,0xA2,0x9C,0x4A,0x36,0xF5,0x7E,0x31,0xBB,0xCD,0x5D,
            0x3B,0xEE,0x20,0x3D,0x80,0xDE,0x4B,0xAD,0x76,0x24,0x2C,0xF4,0x4E,0x34,0x0D,0x11,
            0x14,0xD2,0x94,0x36,0x3F,0xB3,0xDD,0x1D,0x3A,0x00,0x51,0x7A,0xE3,0x8B,0x62,0x73,
            0x53,0x0B,0xF3,0xAD,0xD5,0x95,0xE2,0xB3,0xD7,0x6D,0xB4,0x8A,0xEF,0xE0,0x6C,0x57,
            0xCA,0xF3,0xA3,0x8B,0x91,0x87,0xCC,0x0A,0xD1,0x91,0x7C,0xFB,0xF1,0x35,0x07,0x27,
            0x09,0xAF,0x75,0x3A,0x98,0x13,0xF3,0x96,0x07,0x05,0xFF,0x94,0xA3,0xB8,0xB5,0x22,
            0x60,0xF8,0x8A,0x0A,0x4A,0xCD,0xD2,0x1A,0x4B,0x57,0xAD,0xB6,0x96,0x48,0x52,0xE1,
            0xC7,0x63,0xED,0xAB,0x67,0x07,0x4A,0x05,0x21,0xAB,0x58,0xBB,0x75,0xD1,0x3B,0xE0,
            0x00,0xB9,0xC0,0x11,0x27,0x8C,0xDB,0xFF,0x29,0xF4,0x7B,0x17,0x85,0xEB,0x38,0xDB,
            0x48,0xA1,0x6E,0x6D,0x6B,0x4C,0x08,0xD4,0x46,0x07,0x7A,0x6B,0x3A,0xEB,0xB0,0x2C,
            0x54,0x3F,0x26,0xBE,0x41,0xBC,0x96,0x61,0x9E,0xD0,0xF1,0x5C,0xA6,0x89,0x59,0xB3,
            0x7B,0x5C,0xB6,0xCC,0xC7,0x84,0x58,0xBD,0xBF,0x3E,0x3A,0xB8,0xE2,0x2D,0xC3,0xDA,
            0x63,0x63,0xFD,0x02,0xAF,0xA7,0xD9,0x31,0x1A,0x76,0x9B,0xE8,0x28,0x9A,0x31,0xE4,
            0x64,0x3F,0x3F,0xB7,0xCE,0xB2,0xC0,0xDD,0xBF,0xEF,0x42,0xB8,0xEE,0x96,0x42,0x71,
            0xBA,0xCA,0x01,0x04,0x0E,0xDB,0xDC,0x82,0x87,0xD2,0x16,0xA8,0x9E,0x58,0xCA,0x1F,
            0x04,0x8B,0x1E,0x71,0x2B,0x54,0x12,0x22,0xD0,0x4D,0xAC,0x40,0x5F,0x57,0xE5,0xFF,
            0x45,0xC7,0x1E,0xEB,0x3E,0xA4,0x2F,0xE4,0xEA,0xD6,0xAF,0x81,0x36,0xCF,0x9A,0xBD,
            0xB1,0xA5,0x7A,0x8E,0xC0,0x19,0xCE,0x09,0xFC,0x74,0xAD,0x29,0x88,0x5C,0xB3,0xF7
		},
		
		/* TST_Expected_cyclicOperation_data */
		{
		    0x27,0xB3,0x5B,0xDC,0x64,0xCA,0xB1,0x4A,0x37,0x2A,0x75,0xEA,0x3A,0x87,0xA3,0x46,
            0x36,0xCA,0x24,0x05,0x02,0x55,0x37,0x9E,0xAF,0x7E,0xB9,0x49,0x20,0x67,0x60,0x32,
            0xBF,0xD0,0x86,0x68,0x80,0x37,0x5D,0xF9,0xF4,0xBE,0xB0,0x6B,0x07,0x16,0x64,0xED,
            0xF9,0x1A,0xB8,0x24,0x5C,0xE0,0xDB,0xDD,0x70,0x94,0x0A,0xF1,0x4A,0x9E,0x90,0xFE,
            0x57,0xFC,0x68,0x4A,0xC5,0x1C,0x2C,0x18,0x6B,0xB2,0x89,0x49,0xA6,0x65,0xC0,0x3C,
            0x40,0xBA,0xB2,0x51,0xC8,0x43,0x4F,0xA0,0xAA,0x2C,0x4C,0x87,0xAF,0xFD,0x9D,0x2E,
            0x19,0xA7,0x66,0x1D,0x7E,0x26,0x92,0x20,0x16,0xB6,0x93,0xFD,0xAD,0xF3,0xAE,0x5A,
            0xD9,0xD6,0x0A,0xDC,0x9A,0x09,0xE2,0x31,0x0D,0x2A,0x17,0xC3,0x0F,0x9C,0x76,0xFD,
            0x86,0x9E,0xF8,0xC0,0xF2,0x23,0x76,0xAA,0x2C,0x2D,0x76,0x02,0xCB,0x3B,0x44,0xE3,
            0x41,0x3A,0x5F,0x2C,0xF4,0x8B,0x75,0xB9,0x66,0x52,0x68,0x57,0x23,0x4C,0x06,0x47,
            0x03,0xEA,0xC5,0x1B,0xCB,0x86,0x45,0x10,0x10,0x0A,0x25,0xA4,0x84,0xD5,0x61,0xE2,
            0x1D,0xF6,0x35,0xFF,0xF2,0x0E,0x25,0xFA,0x10,0x61,0x54,0xA1,0xBE,0xB4,0x27,0x58,
            0x91,0x35,0x37,0x86,0x41,0x9E,0x87,0x5D,0x0C,0x33,0x1E,0x4A,0xD1,0x5F,0x17,0x06,
            0xD6,0x6E,0x27,0x82,0x1D,0x51,0x63,0x62,0x07,0x06,0x62,0x9B,0x73,0xC9,0xD3,0x1E,
            0x6C,0x55,0xEF,0x71,0xDC,0x75,0xA2,0x9C,0x4A,0x36,0xF5,0x7E,0x31,0xBB,0xCD,0x5D,
            0x3B,0xEE,0x20,0x3D,0x80,0xDE,0x4B,0xAD,0x76,0x24,0x2C,0xF4,0x4E,0x34,0x0D,0x11,
            0xF0,0xCC,0x31,0x0F,0xAF,0xDE,0xB5,0x01,0x7C,0x6F,0x65,0x72,0x00,0x15,0x15,0xEB,
            0xB7,0x84,0x5B,0x92,0x88,0x51,0x03,0x5A,0x94,0x44,0x15,0x10,0xA1,0x02,0xD4,0x09,
            0x6F,0xEC,0x26,0x1F,0x5B,0x1B,0x86,0x6B,0x81,0x26,0xF9,0xD7,0x39,0x36,0x1F,0xBB,
            0xC8,0x86,0x54,0x51,0x20,0x16,0x15,0x7D,0x16,0x8A,0xDA,0xBB,0x67,0xAB,0x7D,0x31,
            0x18,0xCF,0x59,0x7A,0x07,0x16,0x67,0x84,0x26,0xD3,0x0B,0xD5,0xC1,0xB9,0x59,0x51,
            0x61,0x63,0x06,0xB1,0x4A,0x82,0xAE,0x35,0x45,0x63,0x2C,0xBA,0xEB,0x11,0x6D,0xA5,
            0x95,0xDD,0xA8,0x5D,0xD8,0x39,0xEC,0x49,0x76,0xB0,0xE2,0x3A,0xF1,0x8B,0xF7,0xFE,
            0x0C,0x99,0x65,0x88,0xBC,0x8E,0x2E,0x1F,0xB1,0xE4,0x05,0x37,0x25,0xBB,0x14,0x55,
            0x0A,0x5A,0x61,0x77,0x67,0x8A,0xE5,0x72,0x85,0xA3,0xE3,0x96,0x7F,0xB9,0xA5,0x99,
            0x9D,0xD3,0xB7,0xCD,0x3C,0x42,0x21,0xC4,0xB0,0x77,0x23,0x20,0x56,0x8D,0x16,0x06,
            0x33,0x18,0xA0,0x19,0x93,0x2D,0x29,0x8D,0x30,0x0D,0x27,0xB1,0x77,0x59,0x5F,0x12,
            0x3D,0x25,0x67,0x12,0x2C,0x31,0xE8,0xC3,0x74,0x21,0x82,0x7C,0xB7,0x45,0x40,0xB2,
            0x2C,0x58,0xAC,0x03,0x3D,0xB2,0x6F,0x2A,0x12,0x37,0x92,0x95,0x42,0x49,0x8D,0x1C,
            0xE8,0x68,0x4F,0x69,0x3F,0x53,0xA8,0xA0,0x22,0xE4,0x62,0x11,0x7F,0x55,0xD5,0x52,
            0xB0,0xFD,0x5C,0x29,0x65,0x2B,0xD8,0x18,0xEA,0x2C,0x01,0xE6,0x9C,0xEC,0x0B,0xCA,
            0x6F,0x9F,0xE1,0xB3,0x49,0xD9,0x63,0x40,0x5C,0xB6,0x92,0x4A,0x2D,0xCE,0x11,0x49
		},
		/*TST_Key*/
        {0x03,0x5b,0x54,0x5a,0xaa,0x02,0xcd,0xe3,0x6c,0xe2,0x02,0x0c,0xdd,0x0c,0x4a,0x1c},
        /*TST_KeySize*/
        16*sizeof(DxUint8_t)
	},
	#endif
	
};

const int TST_NumberOf_RC4FLOW_AcceptanceTests      = sizeof(TST_RC4FLOW_Acceptance_TestData)/sizeof(TST_RC4FLOW_Acceptance_TestData[0]);

#endif
#endif

